from utils import Config

import hydra
from hydra.core.config_store import ConfigStore
from omegaconf import OmegaConf


@hydra.main(version_base="1.2", config_path="configs/", config_name="config")
def main(config: Config) -> None:
    # Ours
    if config.algo.name == "ours":
      import main_ours as main
    # Ablations
    ##  Ours with feat-based/timestep-based skill (separable skill)
    elif config.algo.name == "ours_sep_skill":
        import main_ours as main
    ##  Ours with fixed lambda (still using main script with different config)
    elif config.algo.name == "ours_fixed_lambda":
      import main_ours as main
    ##  UVFA (still using main script with different config)
    elif config.algo.name == "uvfa":
      import main_ours as main
    # QD
    elif config.algo.name == "me":
        import main_me as main
    elif config.algo.name == "pga_me":
        import main_pga_me as main
    elif config.algo.name == "dcg_me":
        import main_dcg_me as main
    # URL
    elif config.algo.name == "diayn":
        import main_diayn as main
    elif config.algo.name == "smerl":
        import main_smerl as main
    elif config.algo.name == "smerl_reverse":
        import main_smerl_reverse as main
    else:
        raise NotImplementedError

    main.main(config)

if __name__ == "__main__":
    cs = ConfigStore.instance()
    cs.store(name="main", node=Config)
    main()
